/*:
 * @target MZ
 * @plugindesc v1.0.0 HS_LangSimple タイトル言語メニュー非表示パッチ
 * @author HS_Patch
 * @help
 * HS_LangSimple.js が追加している
 * タイトルコマンド「Language / 言語」をタイトルから消します。
 *
 * 【使い方】
 * 1. このファイルを js/plugins フォルダに入れる
 * 2. プラグインマネージャで HS_LangSimple.js の「下」に追加してON
 *
 * ※多言語版ではこのプラグインをOFFまたは未登録にすれば、
 *   これまで通りタイトルで言語選択が表示されます。
 */

(() => {
  "use strict";

  const _HS_LangSimple_HideTitle_makeCommandList =
    Window_TitleCommand.prototype.makeCommandList;

  Window_TitleCommand.prototype.makeCommandList = function () {
    // まず元の（HS_LangSimple を含む）コマンドリストを作る
    _HS_LangSimple_HideTitle_makeCommandList.call(this);

    // その中から symbol が "hs_lang" のものだけ取り除く
    if (Array.isArray(this._list)) {
      this._list = this._list.filter(cmd => cmd.symbol !== "hs_lang");
    }
  };
})();
